<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AuthorizedBuyersMarketplace;

class Deal extends \Google\Collection
{
  /**
   * A placeholder for an undefined buyer permission type.
   */
  public const BUYER_PERMISSION_TYPE_BUYER_PERMISSION_TYPE_UNSPECIFIED = 'BUYER_PERMISSION_TYPE_UNSPECIFIED';
  /**
   * Only the [Deal.negotiating_buyer] can transact on the deal.
   */
  public const BUYER_PERMISSION_TYPE_NEGOTIATOR_ONLY = 'NEGOTIATOR_ONLY';
  /**
   * All buyers under the [Deal.negotiating_buyer]'s bidder can transact on the
   * deal.
   */
  public const BUYER_PERMISSION_TYPE_BIDDER = 'BIDDER';
  /**
   * Default, unspecified deal type.
   */
  public const DEAL_TYPE_DEAL_TYPE_UNSPECIFIED = 'DEAL_TYPE_UNSPECIFIED';
  /**
   * Preferred deals.
   */
  public const DEAL_TYPE_PREFERRED_DEAL = 'PREFERRED_DEAL';
  /**
   * Private auction deals.
   */
  public const DEAL_TYPE_PRIVATE_AUCTION = 'PRIVATE_AUCTION';
  /**
   * Programmatic guaranteed deals.
   */
  public const DEAL_TYPE_PROGRAMMATIC_GUARANTEED = 'PROGRAMMATIC_GUARANTEED';
  protected $collection_key = 'eligibleSeatIds';
  /**
   * Output only. When the client field is populated, this field refers to the
   * buyer who creates and manages the client buyer and gets billed on behalf of
   * the client buyer; when the buyer field is populated, this field is the same
   * value as buyer; when the deal belongs to a media planner account, this
   * field will be empty. Format : `buyers/{buyerAccountId}`
   *
   * @var string
   */
  public $billedBuyer;
  /**
   * Output only. Refers to a buyer in Real-time Bidding API's Buyer resource.
   * Format: `buyers/{buyerAccountId}`
   *
   * @var string
   */
  public $buyer;
  /**
   * Output only. The buyer permission type of the deal.
   *
   * @var string
   */
  public $buyerPermissionType;
  /**
   * Output only. Refers to a Client. Format:
   * `buyers/{buyerAccountId}/clients/{clientAccountid}`
   *
   * @var string
   */
  public $client;
  /**
   * Output only. The time of the deal creation.
   *
   * @var string
   */
  public $createTime;
  protected $creativeRequirementsType = CreativeRequirements::class;
  protected $creativeRequirementsDataType = '';
  /**
   * Output only. Type of deal.
   *
   * @var string
   */
  public $dealType;
  protected $deliveryControlType = DeliveryControl::class;
  protected $deliveryControlDataType = '';
  /**
   * Output only. Free text description for the deal terms.
   *
   * @var string
   */
  public $description;
  /**
   * Output only. The name of the deal. Maximum length of 255 unicode characters
   * is allowed. Control characters are not allowed. Buyers cannot update this
   * field. Note: Not to be confused with name, which is a unique identifier of
   * the deal.
   *
   * @var string
   */
  public $displayName;
  /**
   * Output only. If set, this field contains the list of DSP specific seat ids
   * set by media planners that are eligible to transact on this deal. The seat
   * ID is in the calling DSP's namespace.
   *
   * @var string[]
   */
  public $eligibleSeatIds;
  protected $estimatedGrossSpendType = Money::class;
  protected $estimatedGrossSpendDataType = '';
  /**
   * Proposed flight end time of the deal. This will generally be stored in a
   * granularity of a second. A value is not necessary for Private Auction
   * deals.
   *
   * @var string
   */
  public $flightEndTime;
  /**
   * Proposed flight start time of the deal. This will generally be stored in
   * the granularity of one second since deal serving starts at seconds
   * boundary. Any time specified with more granularity (for example, in
   * milliseconds) will be truncated towards the start of time in seconds.
   *
   * @var string
   */
  public $flightStartTime;
  protected $mediaPlannerType = MediaPlanner::class;
  protected $mediaPlannerDataType = '';
  /**
   * Immutable. The unique identifier of the deal. Auto-generated by the server
   * when a deal is created. Format:
   * buyers/{accountId}/proposals/{proposalId}/deals/{dealId}
   *
   * @var string
   */
  public $name;
  protected $preferredDealTermsType = PreferredDealTerms::class;
  protected $preferredDealTermsDataType = '';
  protected $privateAuctionTermsType = PrivateAuctionTerms::class;
  protected $privateAuctionTermsDataType = '';
  protected $programmaticGuaranteedTermsType = ProgrammaticGuaranteedTerms::class;
  protected $programmaticGuaranteedTermsDataType = '';
  /**
   * Output only. The revision number for the proposal and is the same value as
   * proposal.proposal_revision. Each update to deal causes the proposal
   * revision number to auto-increment. The buyer keeps track of the last
   * revision number they know of and pass it in when making an update. If the
   * head revision number on the server has since incremented, then an ABORTED
   * error is returned during the update operation to let the buyer know that a
   * subsequent update was made.
   *
   * @var string
   */
  public $proposalRevision;
  /**
   * Immutable. Reference to the seller on the deal. Format:
   * `buyers/{buyerAccountId}/publisherProfiles/{publisherProfileId}`
   *
   * @var string
   */
  public $publisherProfile;
  protected $sellerTimeZoneType = TimeZone::class;
  protected $sellerTimeZoneDataType = '';
  protected $targetingType = MarketplaceTargeting::class;
  protected $targetingDataType = '';
  /**
   * Output only. The time when the deal was last updated.
   *
   * @var string
   */
  public $updateTime;

  /**
   * Output only. When the client field is populated, this field refers to the
   * buyer who creates and manages the client buyer and gets billed on behalf of
   * the client buyer; when the buyer field is populated, this field is the same
   * value as buyer; when the deal belongs to a media planner account, this
   * field will be empty. Format : `buyers/{buyerAccountId}`
   *
   * @param string $billedBuyer
   */
  public function setBilledBuyer($billedBuyer)
  {
    $this->billedBuyer = $billedBuyer;
  }
  /**
   * @return string
   */
  public function getBilledBuyer()
  {
    return $this->billedBuyer;
  }
  /**
   * Output only. Refers to a buyer in Real-time Bidding API's Buyer resource.
   * Format: `buyers/{buyerAccountId}`
   *
   * @param string $buyer
   */
  public function setBuyer($buyer)
  {
    $this->buyer = $buyer;
  }
  /**
   * @return string
   */
  public function getBuyer()
  {
    return $this->buyer;
  }
  /**
   * Output only. The buyer permission type of the deal.
   *
   * Accepted values: BUYER_PERMISSION_TYPE_UNSPECIFIED, NEGOTIATOR_ONLY, BIDDER
   *
   * @param self::BUYER_PERMISSION_TYPE_* $buyerPermissionType
   */
  public function setBuyerPermissionType($buyerPermissionType)
  {
    $this->buyerPermissionType = $buyerPermissionType;
  }
  /**
   * @return self::BUYER_PERMISSION_TYPE_*
   */
  public function getBuyerPermissionType()
  {
    return $this->buyerPermissionType;
  }
  /**
   * Output only. Refers to a Client. Format:
   * `buyers/{buyerAccountId}/clients/{clientAccountid}`
   *
   * @param string $client
   */
  public function setClient($client)
  {
    $this->client = $client;
  }
  /**
   * @return string
   */
  public function getClient()
  {
    return $this->client;
  }
  /**
   * Output only. The time of the deal creation.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Output only. Metadata about the creatives of this deal.
   *
   * @param CreativeRequirements $creativeRequirements
   */
  public function setCreativeRequirements(CreativeRequirements $creativeRequirements)
  {
    $this->creativeRequirements = $creativeRequirements;
  }
  /**
   * @return CreativeRequirements
   */
  public function getCreativeRequirements()
  {
    return $this->creativeRequirements;
  }
  /**
   * Output only. Type of deal.
   *
   * Accepted values: DEAL_TYPE_UNSPECIFIED, PREFERRED_DEAL, PRIVATE_AUCTION,
   * PROGRAMMATIC_GUARANTEED
   *
   * @param self::DEAL_TYPE_* $dealType
   */
  public function setDealType($dealType)
  {
    $this->dealType = $dealType;
  }
  /**
   * @return self::DEAL_TYPE_*
   */
  public function getDealType()
  {
    return $this->dealType;
  }
  /**
   * Output only. Specifies the pacing set by the publisher.
   *
   * @param DeliveryControl $deliveryControl
   */
  public function setDeliveryControl(DeliveryControl $deliveryControl)
  {
    $this->deliveryControl = $deliveryControl;
  }
  /**
   * @return DeliveryControl
   */
  public function getDeliveryControl()
  {
    return $this->deliveryControl;
  }
  /**
   * Output only. Free text description for the deal terms.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Output only. The name of the deal. Maximum length of 255 unicode characters
   * is allowed. Control characters are not allowed. Buyers cannot update this
   * field. Note: Not to be confused with name, which is a unique identifier of
   * the deal.
   *
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * Output only. If set, this field contains the list of DSP specific seat ids
   * set by media planners that are eligible to transact on this deal. The seat
   * ID is in the calling DSP's namespace.
   *
   * @param string[] $eligibleSeatIds
   */
  public function setEligibleSeatIds($eligibleSeatIds)
  {
    $this->eligibleSeatIds = $eligibleSeatIds;
  }
  /**
   * @return string[]
   */
  public function getEligibleSeatIds()
  {
    return $this->eligibleSeatIds;
  }
  /**
   * Specified by buyers in request for proposal (RFP) to notify publisher the
   * total estimated spend for the proposal. Publishers will receive this
   * information and send back proposed deals accordingly.
   *
   * @param Money $estimatedGrossSpend
   */
  public function setEstimatedGrossSpend(Money $estimatedGrossSpend)
  {
    $this->estimatedGrossSpend = $estimatedGrossSpend;
  }
  /**
   * @return Money
   */
  public function getEstimatedGrossSpend()
  {
    return $this->estimatedGrossSpend;
  }
  /**
   * Proposed flight end time of the deal. This will generally be stored in a
   * granularity of a second. A value is not necessary for Private Auction
   * deals.
   *
   * @param string $flightEndTime
   */
  public function setFlightEndTime($flightEndTime)
  {
    $this->flightEndTime = $flightEndTime;
  }
  /**
   * @return string
   */
  public function getFlightEndTime()
  {
    return $this->flightEndTime;
  }
  /**
   * Proposed flight start time of the deal. This will generally be stored in
   * the granularity of one second since deal serving starts at seconds
   * boundary. Any time specified with more granularity (for example, in
   * milliseconds) will be truncated towards the start of time in seconds.
   *
   * @param string $flightStartTime
   */
  public function setFlightStartTime($flightStartTime)
  {
    $this->flightStartTime = $flightStartTime;
  }
  /**
   * @return string
   */
  public function getFlightStartTime()
  {
    return $this->flightStartTime;
  }
  /**
   * Output only. Refers to a buyer in Real-time Bidding API's Buyer resource.
   * This field represents a media planner (For example, agency or big
   * advertiser).
   *
   * @param MediaPlanner $mediaPlanner
   */
  public function setMediaPlanner(MediaPlanner $mediaPlanner)
  {
    $this->mediaPlanner = $mediaPlanner;
  }
  /**
   * @return MediaPlanner
   */
  public function getMediaPlanner()
  {
    return $this->mediaPlanner;
  }
  /**
   * Immutable. The unique identifier of the deal. Auto-generated by the server
   * when a deal is created. Format:
   * buyers/{accountId}/proposals/{proposalId}/deals/{dealId}
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * The terms for preferred deals.
   *
   * @param PreferredDealTerms $preferredDealTerms
   */
  public function setPreferredDealTerms(PreferredDealTerms $preferredDealTerms)
  {
    $this->preferredDealTerms = $preferredDealTerms;
  }
  /**
   * @return PreferredDealTerms
   */
  public function getPreferredDealTerms()
  {
    return $this->preferredDealTerms;
  }
  /**
   * The terms for private auction deals.
   *
   * @param PrivateAuctionTerms $privateAuctionTerms
   */
  public function setPrivateAuctionTerms(PrivateAuctionTerms $privateAuctionTerms)
  {
    $this->privateAuctionTerms = $privateAuctionTerms;
  }
  /**
   * @return PrivateAuctionTerms
   */
  public function getPrivateAuctionTerms()
  {
    return $this->privateAuctionTerms;
  }
  /**
   * The terms for programmatic guaranteed deals.
   *
   * @param ProgrammaticGuaranteedTerms $programmaticGuaranteedTerms
   */
  public function setProgrammaticGuaranteedTerms(ProgrammaticGuaranteedTerms $programmaticGuaranteedTerms)
  {
    $this->programmaticGuaranteedTerms = $programmaticGuaranteedTerms;
  }
  /**
   * @return ProgrammaticGuaranteedTerms
   */
  public function getProgrammaticGuaranteedTerms()
  {
    return $this->programmaticGuaranteedTerms;
  }
  /**
   * Output only. The revision number for the proposal and is the same value as
   * proposal.proposal_revision. Each update to deal causes the proposal
   * revision number to auto-increment. The buyer keeps track of the last
   * revision number they know of and pass it in when making an update. If the
   * head revision number on the server has since incremented, then an ABORTED
   * error is returned during the update operation to let the buyer know that a
   * subsequent update was made.
   *
   * @param string $proposalRevision
   */
  public function setProposalRevision($proposalRevision)
  {
    $this->proposalRevision = $proposalRevision;
  }
  /**
   * @return string
   */
  public function getProposalRevision()
  {
    return $this->proposalRevision;
  }
  /**
   * Immutable. Reference to the seller on the deal. Format:
   * `buyers/{buyerAccountId}/publisherProfiles/{publisherProfileId}`
   *
   * @param string $publisherProfile
   */
  public function setPublisherProfile($publisherProfile)
  {
    $this->publisherProfile = $publisherProfile;
  }
  /**
   * @return string
   */
  public function getPublisherProfile()
  {
    return $this->publisherProfile;
  }
  /**
   * Output only. Time zone of the seller used to mark the boundaries of a day
   * for daypart targeting and CPD billing.
   *
   * @param TimeZone $sellerTimeZone
   */
  public function setSellerTimeZone(TimeZone $sellerTimeZone)
  {
    $this->sellerTimeZone = $sellerTimeZone;
  }
  /**
   * @return TimeZone
   */
  public function getSellerTimeZone()
  {
    return $this->sellerTimeZone;
  }
  /**
   * Specifies the subset of inventory targeted by the deal. Can be updated by
   * the buyer before the deal is finalized.
   *
   * @param MarketplaceTargeting $targeting
   */
  public function setTargeting(MarketplaceTargeting $targeting)
  {
    $this->targeting = $targeting;
  }
  /**
   * @return MarketplaceTargeting
   */
  public function getTargeting()
  {
    return $this->targeting;
  }
  /**
   * Output only. The time when the deal was last updated.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Deal::class, 'Google_Service_AuthorizedBuyersMarketplace_Deal');
