<?php
/**
 * SplitOrderReconSuccessResponseSettlement
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Cashfree Payment Gateway APIs
 *
 * Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.
 *
 * The version of the OpenAPI document: 2025-01-01
 * Contact: developers@cashfree.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cashfree\Model;

use \ArrayAccess;
use \Cashfree\ObjectSerializer;

/**
 * SplitOrderReconSuccessResponseSettlement Class Doc Comment
 *
 * @category Class
 * @description Details of the settlement information.
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class SplitOrderReconSuccessResponseSettlement implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'SplitOrderReconSuccessResponse_settlement';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'entity' => 'string',
        'cf_settlement_id' => 'int',
        'cf_payment_id' => 'int',
        'order_id' => 'string',
        'order_currency' => 'string',
        'transfer_id' => 'string',
        'order_amount' => 'float',
        'service_charge' => 'float',
        'service_tax' => 'float',
        'settlement_amount' => 'float',
        'settlement_currency' => 'string',
        'transfer_utr' => 'string',
        'transfer_time' => '\DateTime',
        'payment_time' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'entity' => null,
        'cf_settlement_id' => 'int64',
        'cf_payment_id' => 'int64',
        'order_id' => null,
        'order_currency' => null,
        'transfer_id' => null,
        'order_amount' => 'float64',
        'service_charge' => 'float64',
        'service_tax' => 'float64',
        'settlement_amount' => 'float64',
        'settlement_currency' => null,
        'transfer_utr' => null,
        'transfer_time' => 'date-time',
        'payment_time' => 'date-time'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'entity' => false,
		'cf_settlement_id' => false,
		'cf_payment_id' => false,
		'order_id' => false,
		'order_currency' => false,
		'transfer_id' => true,
		'order_amount' => false,
		'service_charge' => false,
		'service_tax' => false,
		'settlement_amount' => false,
		'settlement_currency' => false,
		'transfer_utr' => true,
		'transfer_time' => true,
		'payment_time' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'entity' => 'entity',
        'cf_settlement_id' => 'cf_settlement_id',
        'cf_payment_id' => 'cf_payment_id',
        'order_id' => 'order_id',
        'order_currency' => 'order_currency',
        'transfer_id' => 'transfer_id',
        'order_amount' => 'order_amount',
        'service_charge' => 'service_charge',
        'service_tax' => 'service_tax',
        'settlement_amount' => 'settlement_amount',
        'settlement_currency' => 'settlement_currency',
        'transfer_utr' => 'transfer_utr',
        'transfer_time' => 'transfer_time',
        'payment_time' => 'payment_time'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'entity' => 'setEntity',
        'cf_settlement_id' => 'setCfSettlementId',
        'cf_payment_id' => 'setCfPaymentId',
        'order_id' => 'setOrderId',
        'order_currency' => 'setOrderCurrency',
        'transfer_id' => 'setTransferId',
        'order_amount' => 'setOrderAmount',
        'service_charge' => 'setServiceCharge',
        'service_tax' => 'setServiceTax',
        'settlement_amount' => 'setSettlementAmount',
        'settlement_currency' => 'setSettlementCurrency',
        'transfer_utr' => 'setTransferUtr',
        'transfer_time' => 'setTransferTime',
        'payment_time' => 'setPaymentTime'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'entity' => 'getEntity',
        'cf_settlement_id' => 'getCfSettlementId',
        'cf_payment_id' => 'getCfPaymentId',
        'order_id' => 'getOrderId',
        'order_currency' => 'getOrderCurrency',
        'transfer_id' => 'getTransferId',
        'order_amount' => 'getOrderAmount',
        'service_charge' => 'getServiceCharge',
        'service_tax' => 'getServiceTax',
        'settlement_amount' => 'getSettlementAmount',
        'settlement_currency' => 'getSettlementCurrency',
        'transfer_utr' => 'getTransferUtr',
        'transfer_time' => 'getTransferTime',
        'payment_time' => 'getPaymentTime'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('entity', $data ?? [], null);
        $this->setIfExists('cf_settlement_id', $data ?? [], null);
        $this->setIfExists('cf_payment_id', $data ?? [], null);
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('order_currency', $data ?? [], null);
        $this->setIfExists('transfer_id', $data ?? [], null);
        $this->setIfExists('order_amount', $data ?? [], null);
        $this->setIfExists('service_charge', $data ?? [], null);
        $this->setIfExists('service_tax', $data ?? [], null);
        $this->setIfExists('settlement_amount', $data ?? [], null);
        $this->setIfExists('settlement_currency', $data ?? [], null);
        $this->setIfExists('transfer_utr', $data ?? [], null);
        $this->setIfExists('transfer_time', $data ?? [], null);
        $this->setIfExists('payment_time', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets entity
     *
     * @return string|null
     */
    public function getEntity()
    {
        return $this->container['entity'];
    }

    /**
     * Sets entity
     *
     * @param string|null $entity Type of entity. Example: \"settlement\".
     *
     * @return self
     */
    public function setEntity($entity)
    {
        if (is_null($entity)) {
            throw new \InvalidArgumentException('non-nullable entity cannot be null');
        }
        $this->container['entity'] = $entity;

        return $this;
    }

    /**
     * Gets cf_settlement_id
     *
     * @return int|null
     */
    public function getCfSettlementId()
    {
        return $this->container['cf_settlement_id'];
    }

    /**
     * Sets cf_settlement_id
     *
     * @param int|null $cf_settlement_id Unique Cashfree settlement ID.
     *
     * @return self
     */
    public function setCfSettlementId($cf_settlement_id)
    {
        if (is_null($cf_settlement_id)) {
            throw new \InvalidArgumentException('non-nullable cf_settlement_id cannot be null');
        }
        $this->container['cf_settlement_id'] = $cf_settlement_id;

        return $this;
    }

    /**
     * Gets cf_payment_id
     *
     * @return int|null
     */
    public function getCfPaymentId()
    {
        return $this->container['cf_payment_id'];
    }

    /**
     * Sets cf_payment_id
     *
     * @param int|null $cf_payment_id Unique Cashfree payment ID associated with the order.
     *
     * @return self
     */
    public function setCfPaymentId($cf_payment_id)
    {
        if (is_null($cf_payment_id)) {
            throw new \InvalidArgumentException('non-nullable cf_payment_id cannot be null');
        }
        $this->container['cf_payment_id'] = $cf_payment_id;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id Unique identifier for the order.
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets order_currency
     *
     * @return string|null
     */
    public function getOrderCurrency()
    {
        return $this->container['order_currency'];
    }

    /**
     * Sets order_currency
     *
     * @param string|null $order_currency Currency of the order. Example: \"INR\".
     *
     * @return self
     */
    public function setOrderCurrency($order_currency)
    {
        if (is_null($order_currency)) {
            throw new \InvalidArgumentException('non-nullable order_currency cannot be null');
        }
        $this->container['order_currency'] = $order_currency;

        return $this;
    }

    /**
     * Gets transfer_id
     *
     * @return string|null
     */
    public function getTransferId()
    {
        return $this->container['transfer_id'];
    }

    /**
     * Sets transfer_id
     *
     * @param string|null $transfer_id Unique transfer ID if available, otherwise null.
     *
     * @return self
     */
    public function setTransferId($transfer_id)
    {
        if (is_null($transfer_id)) {
            array_push($this->openAPINullablesSetToNull, 'transfer_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('transfer_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['transfer_id'] = $transfer_id;

        return $this;
    }

    /**
     * Gets order_amount
     *
     * @return float|null
     */
    public function getOrderAmount()
    {
        return $this->container['order_amount'];
    }

    /**
     * Sets order_amount
     *
     * @param float|null $order_amount Total amount of the order.
     *
     * @return self
     */
    public function setOrderAmount($order_amount)
    {
        if (is_null($order_amount)) {
            throw new \InvalidArgumentException('non-nullable order_amount cannot be null');
        }
        $this->container['order_amount'] = $order_amount;

        return $this;
    }

    /**
     * Gets service_charge
     *
     * @return float|null
     */
    public function getServiceCharge()
    {
        return $this->container['service_charge'];
    }

    /**
     * Sets service_charge
     *
     * @param float|null $service_charge Service charge for the order.
     *
     * @return self
     */
    public function setServiceCharge($service_charge)
    {
        if (is_null($service_charge)) {
            throw new \InvalidArgumentException('non-nullable service_charge cannot be null');
        }
        $this->container['service_charge'] = $service_charge;

        return $this;
    }

    /**
     * Gets service_tax
     *
     * @return float|null
     */
    public function getServiceTax()
    {
        return $this->container['service_tax'];
    }

    /**
     * Sets service_tax
     *
     * @param float|null $service_tax Service tax for the order.
     *
     * @return self
     */
    public function setServiceTax($service_tax)
    {
        if (is_null($service_tax)) {
            throw new \InvalidArgumentException('non-nullable service_tax cannot be null');
        }
        $this->container['service_tax'] = $service_tax;

        return $this;
    }

    /**
     * Gets settlement_amount
     *
     * @return float|null
     */
    public function getSettlementAmount()
    {
        return $this->container['settlement_amount'];
    }

    /**
     * Sets settlement_amount
     *
     * @param float|null $settlement_amount Amount to be settled after charges and tax.
     *
     * @return self
     */
    public function setSettlementAmount($settlement_amount)
    {
        if (is_null($settlement_amount)) {
            throw new \InvalidArgumentException('non-nullable settlement_amount cannot be null');
        }
        $this->container['settlement_amount'] = $settlement_amount;

        return $this;
    }

    /**
     * Gets settlement_currency
     *
     * @return string|null
     */
    public function getSettlementCurrency()
    {
        return $this->container['settlement_currency'];
    }

    /**
     * Sets settlement_currency
     *
     * @param string|null $settlement_currency Currency of the settlement. Example: \"INR\".
     *
     * @return self
     */
    public function setSettlementCurrency($settlement_currency)
    {
        if (is_null($settlement_currency)) {
            throw new \InvalidArgumentException('non-nullable settlement_currency cannot be null');
        }
        $this->container['settlement_currency'] = $settlement_currency;

        return $this;
    }

    /**
     * Gets transfer_utr
     *
     * @return string|null
     */
    public function getTransferUtr()
    {
        return $this->container['transfer_utr'];
    }

    /**
     * Sets transfer_utr
     *
     * @param string|null $transfer_utr UTR (Unique Transaction Reference) for the transfer if available, otherwise null.
     *
     * @return self
     */
    public function setTransferUtr($transfer_utr)
    {
        if (is_null($transfer_utr)) {
            array_push($this->openAPINullablesSetToNull, 'transfer_utr');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('transfer_utr', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['transfer_utr'] = $transfer_utr;

        return $this;
    }

    /**
     * Gets transfer_time
     *
     * @return \DateTime|null
     */
    public function getTransferTime()
    {
        return $this->container['transfer_time'];
    }

    /**
     * Sets transfer_time
     *
     * @param \DateTime|null $transfer_time Time of transfer if available, otherwise null.
     *
     * @return self
     */
    public function setTransferTime($transfer_time)
    {
        if (is_null($transfer_time)) {
            array_push($this->openAPINullablesSetToNull, 'transfer_time');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('transfer_time', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['transfer_time'] = $transfer_time;

        return $this;
    }

    /**
     * Gets payment_time
     *
     * @return \DateTime|null
     */
    public function getPaymentTime()
    {
        return $this->container['payment_time'];
    }

    /**
     * Sets payment_time
     *
     * @param \DateTime|null $payment_time Timestamp when payment was made.
     *
     * @return self
     */
    public function setPaymentTime($payment_time)
    {
        if (is_null($payment_time)) {
            throw new \InvalidArgumentException('non-nullable payment_time cannot be null');
        }
        $this->container['payment_time'] = $payment_time;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


