<?php
/**
 * SettlementEntity
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Cashfree Payment Gateway APIs
 *
 * Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.
 *
 * The version of the OpenAPI document: 2025-01-01
 * Contact: developers@cashfree.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cashfree\Model;

use \ArrayAccess;
use \Cashfree\ObjectSerializer;

/**
 * SettlementEntity Class Doc Comment
 *
 * @category Class
 * @description Settlement entity object
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class SettlementEntity implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'SettlementEntity';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'cf_payment_id' => 'string',
        'cf_settlement_id' => 'string',
        'settlement_currency' => 'string',
        'order_id' => 'string',
        'entity' => 'string',
        'order_amount' => 'float',
        'payment_time' => 'string',
        'service_charge' => 'float',
        'service_tax' => 'float',
        'settlement_amount' => 'float',
        'settlement_id' => 'int',
        'transfer_id' => 'int',
        'transfer_time' => 'string',
        'transfer_utr' => 'string',
        'forex_conversion_handling_charge' => 'float',
        'forex_conversion_handling_tax' => 'float',
        'forex_conversion_rate' => 'float',
        'charges_currency' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'cf_payment_id' => null,
        'cf_settlement_id' => null,
        'settlement_currency' => null,
        'order_id' => null,
        'entity' => null,
        'order_amount' => null,
        'payment_time' => null,
        'service_charge' => null,
        'service_tax' => null,
        'settlement_amount' => null,
        'settlement_id' => null,
        'transfer_id' => null,
        'transfer_time' => null,
        'transfer_utr' => null,
        'forex_conversion_handling_charge' => null,
        'forex_conversion_handling_tax' => null,
        'forex_conversion_rate' => null,
        'charges_currency' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'cf_payment_id' => false,
		'cf_settlement_id' => false,
		'settlement_currency' => false,
		'order_id' => false,
		'entity' => false,
		'order_amount' => false,
		'payment_time' => false,
		'service_charge' => false,
		'service_tax' => false,
		'settlement_amount' => false,
		'settlement_id' => false,
		'transfer_id' => false,
		'transfer_time' => false,
		'transfer_utr' => false,
		'forex_conversion_handling_charge' => false,
		'forex_conversion_handling_tax' => false,
		'forex_conversion_rate' => false,
		'charges_currency' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'cf_payment_id' => 'cf_payment_id',
        'cf_settlement_id' => 'cf_settlement_id',
        'settlement_currency' => 'settlement_currency',
        'order_id' => 'order_id',
        'entity' => 'entity',
        'order_amount' => 'order_amount',
        'payment_time' => 'payment_time',
        'service_charge' => 'service_charge',
        'service_tax' => 'service_tax',
        'settlement_amount' => 'settlement_amount',
        'settlement_id' => 'settlement_id',
        'transfer_id' => 'transfer_id',
        'transfer_time' => 'transfer_time',
        'transfer_utr' => 'transfer_utr',
        'forex_conversion_handling_charge' => 'forex_conversion_handling_charge',
        'forex_conversion_handling_tax' => 'forex_conversion_handling_tax',
        'forex_conversion_rate' => 'forex_conversion_rate',
        'charges_currency' => 'charges_currency'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'cf_payment_id' => 'setCfPaymentId',
        'cf_settlement_id' => 'setCfSettlementId',
        'settlement_currency' => 'setSettlementCurrency',
        'order_id' => 'setOrderId',
        'entity' => 'setEntity',
        'order_amount' => 'setOrderAmount',
        'payment_time' => 'setPaymentTime',
        'service_charge' => 'setServiceCharge',
        'service_tax' => 'setServiceTax',
        'settlement_amount' => 'setSettlementAmount',
        'settlement_id' => 'setSettlementId',
        'transfer_id' => 'setTransferId',
        'transfer_time' => 'setTransferTime',
        'transfer_utr' => 'setTransferUtr',
        'forex_conversion_handling_charge' => 'setForexConversionHandlingCharge',
        'forex_conversion_handling_tax' => 'setForexConversionHandlingTax',
        'forex_conversion_rate' => 'setForexConversionRate',
        'charges_currency' => 'setChargesCurrency'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'cf_payment_id' => 'getCfPaymentId',
        'cf_settlement_id' => 'getCfSettlementId',
        'settlement_currency' => 'getSettlementCurrency',
        'order_id' => 'getOrderId',
        'entity' => 'getEntity',
        'order_amount' => 'getOrderAmount',
        'payment_time' => 'getPaymentTime',
        'service_charge' => 'getServiceCharge',
        'service_tax' => 'getServiceTax',
        'settlement_amount' => 'getSettlementAmount',
        'settlement_id' => 'getSettlementId',
        'transfer_id' => 'getTransferId',
        'transfer_time' => 'getTransferTime',
        'transfer_utr' => 'getTransferUtr',
        'forex_conversion_handling_charge' => 'getForexConversionHandlingCharge',
        'forex_conversion_handling_tax' => 'getForexConversionHandlingTax',
        'forex_conversion_rate' => 'getForexConversionRate',
        'charges_currency' => 'getChargesCurrency'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('cf_payment_id', $data ?? [], null);
        $this->setIfExists('cf_settlement_id', $data ?? [], null);
        $this->setIfExists('settlement_currency', $data ?? [], null);
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('entity', $data ?? [], null);
        $this->setIfExists('order_amount', $data ?? [], null);
        $this->setIfExists('payment_time', $data ?? [], null);
        $this->setIfExists('service_charge', $data ?? [], null);
        $this->setIfExists('service_tax', $data ?? [], null);
        $this->setIfExists('settlement_amount', $data ?? [], null);
        $this->setIfExists('settlement_id', $data ?? [], null);
        $this->setIfExists('transfer_id', $data ?? [], null);
        $this->setIfExists('transfer_time', $data ?? [], null);
        $this->setIfExists('transfer_utr', $data ?? [], null);
        $this->setIfExists('forex_conversion_handling_charge', $data ?? [], null);
        $this->setIfExists('forex_conversion_handling_tax', $data ?? [], null);
        $this->setIfExists('forex_conversion_rate', $data ?? [], null);
        $this->setIfExists('charges_currency', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets cf_payment_id
     *
     * @return string|null
     */
    public function getCfPaymentId()
    {
        return $this->container['cf_payment_id'];
    }

    /**
     * Sets cf_payment_id
     *
     * @param string|null $cf_payment_id cf_payment_id
     *
     * @return self
     */
    public function setCfPaymentId($cf_payment_id)
    {
        if (is_null($cf_payment_id)) {
            throw new \InvalidArgumentException('non-nullable cf_payment_id cannot be null');
        }
        $this->container['cf_payment_id'] = $cf_payment_id;

        return $this;
    }

    /**
     * Gets cf_settlement_id
     *
     * @return string|null
     */
    public function getCfSettlementId()
    {
        return $this->container['cf_settlement_id'];
    }

    /**
     * Sets cf_settlement_id
     *
     * @param string|null $cf_settlement_id cf_settlement_id
     *
     * @return self
     */
    public function setCfSettlementId($cf_settlement_id)
    {
        if (is_null($cf_settlement_id)) {
            throw new \InvalidArgumentException('non-nullable cf_settlement_id cannot be null');
        }
        $this->container['cf_settlement_id'] = $cf_settlement_id;

        return $this;
    }

    /**
     * Gets settlement_currency
     *
     * @return string|null
     */
    public function getSettlementCurrency()
    {
        return $this->container['settlement_currency'];
    }

    /**
     * Sets settlement_currency
     *
     * @param string|null $settlement_currency settlement_currency
     *
     * @return self
     */
    public function setSettlementCurrency($settlement_currency)
    {
        if (is_null($settlement_currency)) {
            throw new \InvalidArgumentException('non-nullable settlement_currency cannot be null');
        }
        $this->container['settlement_currency'] = $settlement_currency;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id order_id
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets entity
     *
     * @return string|null
     */
    public function getEntity()
    {
        return $this->container['entity'];
    }

    /**
     * Sets entity
     *
     * @param string|null $entity entity
     *
     * @return self
     */
    public function setEntity($entity)
    {
        if (is_null($entity)) {
            throw new \InvalidArgumentException('non-nullable entity cannot be null');
        }
        $this->container['entity'] = $entity;

        return $this;
    }

    /**
     * Gets order_amount
     *
     * @return float|null
     */
    public function getOrderAmount()
    {
        return $this->container['order_amount'];
    }

    /**
     * Sets order_amount
     *
     * @param float|null $order_amount order_amount
     *
     * @return self
     */
    public function setOrderAmount($order_amount)
    {
        if (is_null($order_amount)) {
            throw new \InvalidArgumentException('non-nullable order_amount cannot be null');
        }
        $this->container['order_amount'] = $order_amount;

        return $this;
    }

    /**
     * Gets payment_time
     *
     * @return string|null
     */
    public function getPaymentTime()
    {
        return $this->container['payment_time'];
    }

    /**
     * Sets payment_time
     *
     * @param string|null $payment_time payment_time
     *
     * @return self
     */
    public function setPaymentTime($payment_time)
    {
        if (is_null($payment_time)) {
            throw new \InvalidArgumentException('non-nullable payment_time cannot be null');
        }
        $this->container['payment_time'] = $payment_time;

        return $this;
    }

    /**
     * Gets service_charge
     *
     * @return float|null
     */
    public function getServiceCharge()
    {
        return $this->container['service_charge'];
    }

    /**
     * Sets service_charge
     *
     * @param float|null $service_charge service_charge
     *
     * @return self
     */
    public function setServiceCharge($service_charge)
    {
        if (is_null($service_charge)) {
            throw new \InvalidArgumentException('non-nullable service_charge cannot be null');
        }
        $this->container['service_charge'] = $service_charge;

        return $this;
    }

    /**
     * Gets service_tax
     *
     * @return float|null
     */
    public function getServiceTax()
    {
        return $this->container['service_tax'];
    }

    /**
     * Sets service_tax
     *
     * @param float|null $service_tax service_tax
     *
     * @return self
     */
    public function setServiceTax($service_tax)
    {
        if (is_null($service_tax)) {
            throw new \InvalidArgumentException('non-nullable service_tax cannot be null');
        }
        $this->container['service_tax'] = $service_tax;

        return $this;
    }

    /**
     * Gets settlement_amount
     *
     * @return float|null
     */
    public function getSettlementAmount()
    {
        return $this->container['settlement_amount'];
    }

    /**
     * Sets settlement_amount
     *
     * @param float|null $settlement_amount settlement_amount
     *
     * @return self
     */
    public function setSettlementAmount($settlement_amount)
    {
        if (is_null($settlement_amount)) {
            throw new \InvalidArgumentException('non-nullable settlement_amount cannot be null');
        }
        $this->container['settlement_amount'] = $settlement_amount;

        return $this;
    }

    /**
     * Gets settlement_id
     *
     * @return int|null
     */
    public function getSettlementId()
    {
        return $this->container['settlement_id'];
    }

    /**
     * Sets settlement_id
     *
     * @param int|null $settlement_id settlement_id
     *
     * @return self
     */
    public function setSettlementId($settlement_id)
    {
        if (is_null($settlement_id)) {
            throw new \InvalidArgumentException('non-nullable settlement_id cannot be null');
        }
        $this->container['settlement_id'] = $settlement_id;

        return $this;
    }

    /**
     * Gets transfer_id
     *
     * @return int|null
     */
    public function getTransferId()
    {
        return $this->container['transfer_id'];
    }

    /**
     * Sets transfer_id
     *
     * @param int|null $transfer_id transfer_id
     *
     * @return self
     */
    public function setTransferId($transfer_id)
    {
        if (is_null($transfer_id)) {
            throw new \InvalidArgumentException('non-nullable transfer_id cannot be null');
        }
        $this->container['transfer_id'] = $transfer_id;

        return $this;
    }

    /**
     * Gets transfer_time
     *
     * @return string|null
     */
    public function getTransferTime()
    {
        return $this->container['transfer_time'];
    }

    /**
     * Sets transfer_time
     *
     * @param string|null $transfer_time transfer_time
     *
     * @return self
     */
    public function setTransferTime($transfer_time)
    {
        if (is_null($transfer_time)) {
            throw new \InvalidArgumentException('non-nullable transfer_time cannot be null');
        }
        $this->container['transfer_time'] = $transfer_time;

        return $this;
    }

    /**
     * Gets transfer_utr
     *
     * @return string|null
     */
    public function getTransferUtr()
    {
        return $this->container['transfer_utr'];
    }

    /**
     * Sets transfer_utr
     *
     * @param string|null $transfer_utr transfer_utr
     *
     * @return self
     */
    public function setTransferUtr($transfer_utr)
    {
        if (is_null($transfer_utr)) {
            throw new \InvalidArgumentException('non-nullable transfer_utr cannot be null');
        }
        $this->container['transfer_utr'] = $transfer_utr;

        return $this;
    }

    /**
     * Gets forex_conversion_handling_charge
     *
     * @return float|null
     */
    public function getForexConversionHandlingCharge()
    {
        return $this->container['forex_conversion_handling_charge'];
    }

    /**
     * Sets forex_conversion_handling_charge
     *
     * @param float|null $forex_conversion_handling_charge Cashfree forex conversion charges for refund processing
     *
     * @return self
     */
    public function setForexConversionHandlingCharge($forex_conversion_handling_charge)
    {
        if (is_null($forex_conversion_handling_charge)) {
            throw new \InvalidArgumentException('non-nullable forex_conversion_handling_charge cannot be null');
        }
        $this->container['forex_conversion_handling_charge'] = $forex_conversion_handling_charge;

        return $this;
    }

    /**
     * Gets forex_conversion_handling_tax
     *
     * @return float|null
     */
    public function getForexConversionHandlingTax()
    {
        return $this->container['forex_conversion_handling_tax'];
    }

    /**
     * Sets forex_conversion_handling_tax
     *
     * @param float|null $forex_conversion_handling_tax Cashfree forex conversion tax for refund processing
     *
     * @return self
     */
    public function setForexConversionHandlingTax($forex_conversion_handling_tax)
    {
        if (is_null($forex_conversion_handling_tax)) {
            throw new \InvalidArgumentException('non-nullable forex_conversion_handling_tax cannot be null');
        }
        $this->container['forex_conversion_handling_tax'] = $forex_conversion_handling_tax;

        return $this;
    }

    /**
     * Gets forex_conversion_rate
     *
     * @return float|null
     */
    public function getForexConversionRate()
    {
        return $this->container['forex_conversion_rate'];
    }

    /**
     * Sets forex_conversion_rate
     *
     * @param float|null $forex_conversion_rate Cashfree forex conversion rate for refund processing
     *
     * @return self
     */
    public function setForexConversionRate($forex_conversion_rate)
    {
        if (is_null($forex_conversion_rate)) {
            throw new \InvalidArgumentException('non-nullable forex_conversion_rate cannot be null');
        }
        $this->container['forex_conversion_rate'] = $forex_conversion_rate;

        return $this;
    }

    /**
     * Gets charges_currency
     *
     * @return string|null
     */
    public function getChargesCurrency()
    {
        return $this->container['charges_currency'];
    }

    /**
     * Sets charges_currency
     *
     * @param string|null $charges_currency Cashfree refund charges currency for a refund
     *
     * @return self
     */
    public function setChargesCurrency($charges_currency)
    {
        if (is_null($charges_currency)) {
            throw new \InvalidArgumentException('non-nullable charges_currency cannot be null');
        }
        $this->container['charges_currency'] = $charges_currency;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


